<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Modules\EmailSetting\App\Models\EmailTemplate;

class EmailTemplateSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $templates = [
            // --- Order Approved ---
            [
                'name' => 'Seller Level',
                'subject' => 'Seller Level',
                'description' => '<p>Dear <strong>{{name}}</strong>,</p>
                <p>Congratulations! We are excited to inform you that you have successfully crossed into a new seller level :&nbsp;<strong>{{lev_name}}</strong></p>
                <p>This achievement reflects your hard work, dedication, and success in growing your business with us. We look forward to seeing your continued success and are here to support you every step of the way. Keep up the great work!</p>
                <p>&nbsp;</p>
                <p>Best regards,</p>
                <p>Inflanar</p>',
            ],
        ];

        foreach ($templates as $template) {
            EmailTemplate::firstOrCreate(
                ['name' => $template['name']], // check uniqueness by name
                [
                    'subject'     => $template['subject'],
                    'description' => $template['description'],
                    'created_at'  => now(),
                    'updated_at'  => now(),
                ]
            );
        }

    }
}
