<?php

namespace Modules\SellerLevel\Database\Seeders;

use App\Models\User;
use Illuminate\Database\Seeder;
use Modules\SellerLevel\Entities\SellerLevel;
use Modules\SellerLevel\Entities\SellerLevelHistory;

class SellerLevelHistoryDatabaseSedder extends Seeder
{
    /**
     * Run the database seeds.
     */
   public function run(): void
    {
        $users = User::where('is_seller', 1)->get();

        foreach ($users as $user) {
            $level = SellerLevel::findOrFail(1);
            SellerLevelHistory::create([
                'seller_id' => $user->id,
                'seller_level_id' => $level->id,
                'level' => $level->name,
                'assigned_at' => now(),
                'orders_at_assignment' => 0,
                'order_amount_at_assignment' => 0,
            ]);


            User::where('id', $user->id)->update(['current_level_id' => $level->id, 'level_assigned_at' => now()]);
        }

    }
}
